{------------------------------------------------------------------------------}
{ Object Pascal Compiler Conditional Defines Version List                      }
{------------------------------------------------------------------------------}
{ VER90:  Version 9.0  - Delphi 2                                              }
{ VER93:  Version 9.3  - C++ Builder 1                                         }
{ VER100: Version 10.0 - Delphi 3                                              }
{ VER110: Version 11.0 - C++ Builder 3                                         }
{ VER120: Version 12.0 - Delphi 4                                              }
{------------------------------------------------------------------------------}
{ Subsequent versions of Delphi, C++ Builder need to be updated in here        }
{------------------------------------------------------------------------------}

{$B-} // Enable Short-Circuit Evaluation
{$I+} // Handle Run-Time Errors using Exceptions

{$IFNDEF WIN32}
  Sorry, only 32bit versions of Delphi/C++ Builder are supported by Y-Tech Components.
{$ENDIF}

// Idea here is to define everything assume we've got the latest compiler and
// then undefine it if we find out we have an earlier one. This way it's
// guaranteed compatible with the next version of Delphi, and the next, and the
// next...

{$DEFINE Delphi4Up}
{$DEFINE Delphi3Up}
{$DEFINE Delphi2Up}

// Delphi 2 Defines

{$IFDEF VER90}
  {$DEFINE Delphi2}
  {$UNDEF Delphi3Up}
  {$UNDEF Delphi4Up}
{$ENDIF}

// C++ Builder 1 Defines

{$IFDEF VER93}
  {$DEFINE CBuider1}
  {$UNDEF Delphi3Up}
  {$UNDEF Delphi4Up}
{$ENDIF}

// Delphi 3 Defines

{$IFDEF VER100}
  {$DEFINE Delphi3}
  {$UNDEF Delphi4Up}
{$ENDIF}

// C++ Builder 3 Defines

{$IFDEF VER110}
  {$ObjExportAll On}  // C++ Builder needs this defined
  {$DEFINE CBuilder3}
  {$DEFINE CBuilder3Up}
{$ENDIF}

// Delphi 4 Defines

{$IFDEF VER120}
  {$DEFINE Delphi4}
{$ENDIF}
